/****************************************************************************

    PROGRAM:     Generic     Version 2.00 / January 1996


    PURPOSE:     Generic SDI Windows application template

                 This module contains code for the base application object
                 and is the main startup module for the application.

    AUTHOR:      G.Plowman

****************************************************************************/



// Include files
#include "stdafx.h"          // Pre-compiled header

#include "generic.h"         // specific to this program
#include "sdiframe.h"        // Application main window
#include "resource.h"        // Resource ID's (only for class registration)

#include "ctl3d.h"           // 3d controls
    
    
    
// The global application object which starts
// up the whole application.
// Place any global variables/objects before the application object is
// created otherwise they won't be initialised if the application object
// tries to use them.

CTheApp NEAR tgTheApp;





/****************************************************************************

    METHOD:      InitApplication()

    PURPOSE:     Called upon initialisation of the first instance of an
                 application to register any new window classes.
                 These are needed for new window types and nearly always
                 for MDI Child windows so that you can have a different icon
                 when the window is minimised.


    PARAMETERS:  None

    RETURNS:     TRUE  Success
                 FALSE Error

****************************************************************************/

BOOL CTheApp::InitApplication() {

    return TRUE;
}





/****************************************************************************

    METHOD:      InitInstance()

    PURPOSE:     Called upon application instance initialisation to create
                 and show the main application window


    PARAMETERS:  None

    RETURNS:     TRUE  Successfully started up
                 FALSE Error starting up application

****************************************************************************/

BOOL CTheApp::InitInstance() {

    SetDialogBkColor();                          // Hook gray dialogs

    // Set up CTL3DV2.DLL so that dialogs
    // appear with 3d controls
    ::Ctl3dRegister(AfxGetInstanceHandle());
    ::Ctl3dAutoSubclass(AfxGetInstanceHandle());

       
    // Create and show the main application window
    m_pMainWnd = new CMainFrame();
    m_pMainWnd->ShowWindow(SW_SHOW);
    m_pMainWnd->UpdateWindow();

    return TRUE;
}





/****************************************************************************

    METHOD:      ExitInstance()

    PURPOSE:     Cleans up upon exit from application


    PARAMETERS:  None

    RETURNS:     int

****************************************************************************/

int CTheApp::ExitInstance() {

    // Unhook 3d dialogs
    ::Ctl3dUnregister(AfxGetInstanceHandle());   // Unhook 3d controls

    return TRUE;
}





/****************************************************************************

    FUNCTION:    GetApp()

    PURPOSE:     Gets a pointer to the application object

    
    PARAMETERS:  None

    RETURNS:     CTheApp*    Pointer to the application object

****************************************************************************/

CTheApp *GetApp() {
    
    return ((CTheApp*)AfxGetApp());
}





/****************************************************************************

    METHOD:      MESSAGE_MAP

    PURPOSE:     Message map for the CTheApp class

    
    PARAMETERS:  None

    RETURNS:     None

****************************************************************************/

BEGIN_MESSAGE_MAP(CTheApp, CWinApp)
    //{{AFX_MSG_MAP(CTheApp)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()
